
CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE

	MSGFINAL TEXT := 'FOI CRIADA';
	
BEGIN 
	IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_NAME= 'pdv_vd_febrafar') THEN 

CREATE TABLE pdv_vd_febrafar
(
    cd_emp numeric NOT NULL DEFAULT 0,
    cd_filial numeric NOT NULL DEFAULT 0,
    cd_vd numeric NOT NULL DEFAULT 0,
    id_empresa numeric NOT NULL DEFAULT 0,
    nr_cartao character varying(30) COLLATE pg_catalog."default" DEFAULT ''::character varying,
    cpf_cgc character varying(20) COLLATE pg_catalog."default" DEFAULT ''::character varying,
    nr_transacao character varying(30) COLLATE pg_catalog."default" DEFAULT ''::character varying,
    cd_frm_pgto numeric NOT NULL DEFAULT 0,
    vlr_pgto numeric(14,4) NOT NULL DEFAULT 0,
    vlr_aut numeric(14,4) NOT NULL DEFAULT 0,
    prog_desc smallint NOT NULL DEFAULT 0,
    pede_senha smallint NOT NULL DEFAULT 0,
    CONSTRAINT pdv_vd_febrafar_pkey PRIMARY KEY (cd_emp, cd_filial, cd_vd),
    CONSTRAINT pdv_vd_febrafar_pdv_vd_fkey FOREIGN KEY (cd_filial, cd_vd, cd_emp)
        REFERENCES public.pdv_vd (cd_filial, cd_vd, cd_emp) MATCH SIMPLE
        ON UPDATE CASCADE
        ON DELETE CASCADE
);
	ELSE    
		MSGFINAL := 'A TABELA J EXISTE';
	END IF;

	RAISE NOTICE 'TABELA pdv_vd_febrafar %', MSGFINAL::VARCHAR;

END; 
-- FIM BLOCO PRINCIPAL 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
  COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();